let elementary = {"categories":[{"name":"Writing Format and Standards","type":"default","comments":[{"abbreviation":"Heading","comment":"*Revise Heading:*\nType the proper heading in the upper left-hand corner of the first page. The heading includes the writer's full name; the teacher's title and last name; the subject; and the date.\n*Example:*\nJohn Doe\nMr. Pennington\nEnglish\n7 March 2021","id":"Heading0.5804369508923024"},{"abbreviation":"Header","comment":"*Revise Header:*\nUsing right-justified text, type the header in the upper right-hand corner beginning on the first page, one-half inch from the top. Include your last name, followed by the page number. Each page must include your last name and page number in the header.\n*Example:* Doe 1","id":"Header0.4071123341805778"},{"abbreviation":"Title","comment":"*Revise Title:*\nUsing center-justified text, type, and capitalize the title. The first letter is capitalized in each word except articles (_a, an,_ or _the_), and coordinating conjunctions (_for, and, nor, but, or, yet, so_) unless it appears as the first word in the title. Do not boldface, italicize, underline, or use quotation marks for the title.\n*Example:* Walking a Mile","id":"Title0.8799041649001536"},{"abbreviation":"Margins","comment":"*Revise Margins:*\nSet one-inch margins for top, bottom, left, and right except the one-half inch header. Use left-justified text and print on white 8.5 x 11-inch paper if your teacher wants you to print your final draft.","id":"Margins0.9531336414969602"},{"abbreviation":"Spacing","comment":"*Revise Spacing:*\nSet line spacing to double space for all lines, including the header and title. Single space after all punctuation marks, including periods.","id":"Spacing0.7336477854144832"},{"abbreviation":"Citation","comment":"*Revise In-Text Citation Format:*\nIn-text citations identify any outside source of information you use in your writing and must be included on a separate Works Cited page. After the direct quotation (using the author's words) or an indirect quotation (using your own words, but the author's idea), include the following within parentheses: the author's last name (or title if none listed), followed by a space and the page number (numeral only). If the name of the author or title is used within the quotation, only the page number is included in parentheses. Place a period after the closing parenthesis.\n*Examples:*\nAs the author explains, \"Direct quotation\" (Smith 22).\nAccording to Amy Smith, \"Direct quotation\" (22).\nThe author said that...indirect quotation (\"Article Title\" 4).\nIn _The Magician's Nephew..._ indirect quotation (16).","id":"Citation0.2916550661776143"},{"abbreviation":"Font","comment":"*Change Font:*\nType in a standard, black, size 12 font. Never use all upper case letters in words.","id":"Font0.04358911249687503"},{"abbreviation":"WrksCite","comment":"*Revise Works Cited Format:*\nThe Modern Language Association (MLA) has specific rules for providing full references to parenthetical (in-text) citations. Follow these guidelines.","id":"WrksCite0.08690814289539306"},{"abbreviation":"Inc","comment":"*Incomplete:*\nYou seem to understand the writing prompt (assignment) and know what you need to do; however, your work is incomplete. Follow my guidelines to finish and share your best work for me, so I can help you improve your writing.","id":"Inc0.29476741998739064"},{"abbreviation":"Proof","comment":"*Needs Proofreading:*\nYour final draft should be neat and free from writing errors. Make sure to run the spelling check and edit carefully. Read through your final draft out loud to catch any errors.","id":"Proof0.9414428082677084"},{"abbreviation":"Typo","comment":"*Typographical Error:*\nSpelling error due to mistyping. The computer's spellcheck does not catch all typos. Proofread out loud to catch these errors.","id":"Typo0.639877927360109"},{"abbreviation":"NumErr","comment":"*Number Error:*\nFor numbers zero through nine, write out numbers. For 10 and higher, use numbers.\n*Examples:* one, two, three four, five, six, seven, eight, nine, 10, 11, 12...","id":"NumErr0.7623869860081882"},{"abbreviation":"Gap","comment":"*Close Gap:*\nThese two words should be combined as a simple compound word or as a hyphenated word. Use hyphens to join words that are necessarily related, but are not compound words. Don't capitalize the letter following the hyphen.","id":"Gap0.8495103985141137"},{"abbreviation":"Para","comment":"*Needs New Paragraph:*\nStart new paragraphs in essays for new ideas, topics, reasons, or arguments. Start new paragraphs in stories for new events, changes in place, changes in time, and for each new speaker in dialogue. Indent one tab for paragraphs. Don't add additional spacing between paragraphs. If your teacher requires block paragraph style, don't indent new paragraphs; instead, add an additional space between paragraphs.","id":"Para0.9078270132688193"},{"abbreviation":"PosForm","comment":"*Positive Format Comment:*\nYou've done an excellent job, making sure that the writing format is accurate.","id":"PosForm0.7427606057523037"},{"abbreviation":"PosStnd","comment":"*Positive Standards Comment:*\nYou've done a great job, making sure that your final work is near error-free and up to the standards I've set for all of my students' papers. Thank you for doing your best to meet these standards.","id":"PosStnd0.04456524418922414"}],"id":"Writing Format and Standards0.45023740486278263"},{"name":"Essay Structure and Content","type":"default","comments":[{"type":"text","abbreviation":"Intro","comment":"*Revise Introduction:*\nAn essay introduction needs two sentences: a _hook_ and a _summary_ to introduce the thesis statement.\n*▪* The first sentence of your essay is the _hook_. It grabs the attention of your reader. Choose the hook that best matches what the essay is about and your purpose for writing.Two types of hooks work well for essays: a quotation from an expert on the subject of your essay and a startling (surprising or shocking) statement.\n*Expert Quotation Example:* Luis Valdez, author of \"Video Game Injuries,\" claims that \"children under 13 shouldn't play video games.\"\n*Startling Statement Example:* Video games destroy lives.\n*▪* The second sentence of your essay is the _summary_. If you are writing about an issue or topic from a reading or video, begin the summary sentence with the title and name of the author. Then, tell what the issue or topic is about. Use another sentence if you need to do so.\n*Summary Example:* According to Dr. Phoebe Caulkins, in her article titled, \"The Cost of Gaming,\" children spend too much time playing video games when they should be playing outside.","id":"Intro0.1707161740625387"},{"abbreviation":"Opinion","comment":"*Revise Opinion Statement:*\nYour opinion statement must answer the key question you develop from the writing prompt (assignment). In an opinion essay, your thesis statement makes a specific claim about the issue or topic, which you will support throughout the essay. Write your thesis statement as the last sentence of the essay introduction, following the _hook_ and _summary_ sentences. You may choose to preview the body paragraphs by listing key idea words from the topic sentences. Use a transition word to begin the thesis statement.\n*Opinion Essay Example:* However, the positive outcomes of video gaming far outweigh the negatives. Gamers develop better technological skills, increased attention spans, and superior ability to multi-task than those who do not play.","id":"Opinion0.8200771261926976"},{"abbreviation":"Purpose","comment":"*Revise Informative/Explanatory Thesis Statement:*\nReview the writing prompt (assignment). Your thesis statement must answer the key question you develop from the writing prompt (assignment). In an informative/explanatory essay, your thesis statement states the purpose for writing. Write your thesis statement as the last sentence or two of the essay introduction, following the _hook_ and _summary_ sentences. You may choose to preview the body paragraphs by listing key idea words from the topic sentences. Use a transition word to begin the thesis statement.\n*Informative/Explanatory Essay Example:* Video gaming helps young people in two ways. Gamers develop technological skills and learn how to solve problems.","id":"Purpose0.23299965349950202"},{"abbreviation":"TopSent","comment":"*Needs Topic Sentence:*\nWrite a topic sentence as the first sentence of each body paragraph. It usually begins with a transition word and states the main idea of the paragraph. Each topic sentence must talk about your thesis statement. In an opinion essay, each topic sentence states a reason. In an informative/explanatory essay, each topic sentence states a key point or a fact.\n*Example:* First, young people who play video games learn technological skills.","id":"TopSent0.7288579124785106"},{"type":"text","abbreviation":"Detail","comment":"*Needs Concrete Detail:*\nUse specific evidence to support your topic sentences. Use a variety of types of evidence, such as these *FE SCALE Evidence Strategies:* F̲act, E̲xample, S̲tatistic (a percentage), C̲omparison (the similarities and differences), Quote from an A̲uthority (an expert on the issue or topic), L̲ogic (what makes sense), or E̲xperience. Begin each concrete detail with a transition word.\n*Quote from an Authority Example:* For example, the author said, \"Gamers can also learn to program\" (Lee 3).","id":"Detail0.3572914424667042"},{"abbreviation":"Cite","comment":"*Needs Citation:*\nYou need to include a citation for this information and put the source information in your Works Cited page.","id":"Cite0.8389040488455606"},{"abbreviation":"Comment","comment":"*Needs Commentary:*\nProvide your own comments about the concrete detail. In an opinion essay, include your opinion, share your own ideas about the evidence, analyze (say what it means about the issue or topic), or evaluate (say if it's right or wrong; good or bad). In an informative/explanatory essay, explain, analyze (say what it means), or provide a definition of a key word. Commentary does not add additional details or information. Use a transition word to begin commentary sentences.\n*Example:* As a result, gamers learn how to optimize their games with modifications.","id":"Comment0.8354697638788444"},{"abbreviation":"ConSt","comment":"*Needs Concluding Statement:*\nA concluding statement provides a summary about the body paragraph and does not add new evidence or information. It may include a transition word to connect to the next body paragraph.\n*Example:* As a result, playing video games improves the technological skills of gamers and provides another key benefit.","id":"ConSt0.4726299624261794"},{"abbreviation":"ThRest","comment":"*Needs Thesis Restatement:*\nBegin the concluding paragraph of your essay with a thesis restatement. This sentence uses different words for the thesis statement to remind the reader about the focus of the essay.","id":"ThRest0.48591659286887134"},{"type":"text","abbreviation":"Conclsn","comment":"*Revise Conclusion:*\nThe conclusion comments on the evidence presented in the body paragraphs. Use a variety of conclusion comments, such as the *GASES Conclusion Strategies:* G̲eneralization (a statement about something that is usually true), A̲pplication (how the evidence applies or relates to something else), Statement of S̲ignificance (why the evidence is important), E̲mphasis of Key Point (what is the most important point), or S̲ummary Statement. Use a transition word to begin the conclusion comments.\n*Application* *Example:* Additionally, learn how to solve problems teamwork skills, which are becoming increasingly helpful in the school and in the workplace. Indeed, video gaming can be purposeful play.","id":"Conclsn0.4980140309318979"},{"abbreviation":"PosEStr","comment":"*Positive Essay Structure Comment:*\nYour writing has demonstrated an excellent understanding about how an essay should be structured with a hook, summary, and thesis statement in the introduction; body paragraphs with topic sentences, concrete details, commentary, and concluding statements; and a conclusion paragraph with thesis restatement and conclusion strategies.","id":"PosEStr0.48517233094865886"},{"abbreviation":"PosECon","comment":"*Positive Essay Content Comment:*\nYour skillful use of research and information to prepare this essay is impressive. You have used resources from experts on the subject of your writing, and you have also added creative and original thinking in this essay.","id":"PosECon0.48161655292393313"}],"id":"Essay Structure and Content0.06741196883148315"},{"name":"Story Structure and Content","type":"default","comments":[{"abbreviation":"Lead","comment":"*Revise Story Lead:*\nThe first sentence or two of your story should _hook_ your reader's interest. In a story or article, the _hook_ is also called a _lead._ For short stories, try using one of these leads to begin your story:\n*▪* A *dialogue lead* begins the story with a short, but interesting, exciting, or suspenseful conversation between two of the story characters.\n*Example:* \"Did you see that?\" screamed my brother. \"It just about took off my head. Quick, let's get under cover before it comes back!\"\n*▪* An *action lead* begins the story with the main character or characters involved in some kind of exciting, suspenseful, adventurous, or surprising activity.\nAfter the lead, introduce the main character or characters, setting, and any other information that your reader needs to understand your story. This beginning section of your story, including the lead, character introduction, setting, and background is called the _exposition_ (or _basic situation_).","id":"Lead0.6964136760801616"},{"abbreviation":"CharInt","comment":"*Needs Character Introduction:*\nNeeds a more detailed character description to introduce your main character or characters. Following are types of character roles found in many stories. _Tell_ or _show_ the _character traits_ (what makes each person special) through a description or action.\n*▪* The _protagonist_ is the main character who is involved in a conflict. Usually, the protagonist is the hero of the story.\n*▪* The _antagonist_ is the character who opposes the protagonist in the conflict. The antagonist may act as the villain or _bad guy_ in the story.\n*▪* Minor characters appear less often in the story. However, minor characters can influence the plot and other characters.","id":"CharInt0.25744721957579775"},{"abbreviation":"Setting","comment":"*Revise Setting:*\nNeeds more specific setting details. The setting is the time and place of the story.\n*Setting Example:* The factory whistle blew for quitting time: five o'clock, and not a minute too soon on this cloudy January day, far from the cheer of Christmas. The year was 1938. My hometown of Akron, Ohio, was no different than any other boring midwestern town.","id":"Setting0.7649168001695057"},{"abbreviation":"Conflct","comment":"*Revise Conflict:*\nThe conflict is unclear. The conflict is the key problem that the characters face in the plot. The conflict may be _external_ (outside the characters) or _internal_ (inside the characters).\n*External Conflict Examples:* character vs. character, character vs. nature, character vs. technology, character vs. a group of people.\n*Internal Conflict Examples:* character vs. emotions, character vs. needs or desires, character vs. temptations, character vs. the past","id":"Conflct0.9881332511132837"},{"abbreviation":"POV","comment":"*Inconsistent Point of View:*\nThe point of view has changed. The point of view refers to how the story is told. Most authors use one of these points of view to tell the story:\n*▪* One of the characters tells the story using I. The reader only knows what the character knows and feels.\n*Example:* I walked into the hallway, not knowing where it would lead.\n*▪* The narrator, who is not involved in the story, tells the reader what one main character knows and feels.\n*Example:* Marsha and Brad left the house together. Marta wondered if they would return.\n*▪* The narrator or character telling the story knows everything about the characters' past, present, and future.\n*Example:* The children did not know that their parents were waiting for them at the end of the tunnel.","id":"POV0.004159837130567334"},{"abbreviation":"RisAct","comment":"*Needs More Rising Action:*\nNeeds more plot development before the story climax. Rising action is the series of events that develop the characters and the conflict to prepare the reader for the story climax.","id":"RisAct0.8094241855737896"},{"abbreviation":"Climax","comment":"*Revise Climax:*\nNeeds a more detailed climax. The climax is the most exciting part of the story when the characters face the main consequences of the conflict. The climax is usually included toward the end of the story.","id":"Climax0.06483541370761614"},{"abbreviation":"Resltn","comment":"*Revise Resolution:*\nNeeds a more detailed and clear resolution. The resolution follows the climax and resolves the key conflict of the story. It provides a satisfying ending in which the reader discovers what happens to the main characters and how the plot ends.","id":"Resltn0.15434968107089708"},{"type":"text","abbreviation":"CharDev","comment":"*Needs More Character Development:*\nNeeds more detailed and specific character development. Use the *STEAL Characterization Strategy* to create interesting characters: *Speech* (how and what the characters say in dialogue); *Thought* (what the characters think); *Effect* on others (how the characters relate to one another); *Action* (what the characters do and the how they respond to the consequences of their actions); and *Looks* (the appearance of the characters).\nReveal the _character traits_ (what makes each person special) through both _direct_ and _indirect_ characterization.\n_Direct_ characterization _tells_ the reader the character traits through description.\n*Example:* Mr. Tang was patient and focused on the present.\n_Indirect_ characterization _shows_ the character traits through the plot, dialogue, action, and other characters.\n*Example:* His tie was perfectly placed, not too short and not too long.","id":"CharDev0.05351808418572346"},{"abbreviation":"NotChar","comment":"*Inconsistent Characterization:*\nThis doesn't seem to fit your character. Don't surprise or confuse your reader with speech or action that seems _out of character._ Keep consistent with the characterizations which you have already established:\n*▪* A _dynamic_ character changes significantly throughout the narrative. Also referred to as a round character, the character is complex with multiple traits and learns and grows throughout the story.\n*▪* A _static_ character remains the same throughout the narrative.\n*▪* A _flat_ character is a simple, minor character with one personality trait.\nWriters develop characters throughout the story in these ways:","id":"NotChar0.30705194392573043"},{"abbreviation":"Dialog","comment":"*Revise Dialogue:*\nUse these ideas to write good dialogue:\n*▪* Keep speeches short. Don't waste words or say what the reader already knows.\n*▪* Good dialogue adds to the plot and can suggest action.\n*▪* Use realistic vocabulary and write the way your characters speak.\n*▪* Use a variety of speaker tags (other than _said_),and use them only when needed to show the reader whom is speaking.\n*▪* Don't overuse character names in dialogue.\n*▪* Don't use too much \"thinking\" dialogue.","id":"Dialog0.04473010094608054"},{"abbreviation":"Dscrptn","comment":"*Revise Description:*\nGood description uses _show me_, not _tell me_ writing. Use these ideas to write effective description:\n*▪* Description should be specific.\n*Example:* She walked down the stairs into the street.\n*Revision:* She walked down the wooden stairs into Laredo Street.\n*▪* Description should include a variety of the senses (taste, touch, sound, sight, feeling).\n*Example:* The smell of oven-baked cookies and the sounds of an old jazz song welcomed him into the sun-filled room.\n*▪* Description should clearly identify changes in location.\n*Example:* Tasha changed direction, turning onto the one-way street.","id":"Dscrptn0.9744578286184393"},{"abbreviation":"Theme","comment":"*Needs Theme:*\nShort stories, like novels, include a theme. The theme is the main idea which the author explores and writes about in the text. It can be a message or lesson about life that can apply to everyone. Usually, the author provides hints about what the theme is and allows the reader to discover what it.\n*Examples:* Growing up is challenging. Everyone needs love.","id":"Theme0.10628508459280539"},{"abbreviation":"PosStStr","comment":"*Positive Story Structure Comment:*\nYour writing shows that you understand how to start a story with a story lead, main character introductions, setting, and conflict. You've done a great job including the rising action, the climax, and a satisfying resolution that solves the conflict.","id":"PosStStr0.19618246726551658"},{"abbreviation":"PosStCon","comment":"*Positive Story Content Comment:*\nYour characters are realistic, their roles in the story are clear, and their character traits are well-described. The plot is interesting and entertaining. I so enjoyed your creative story.","id":"PosStCon0.9966480537118181"}],"id":"Story Structure and Content0.07016537936219502"},{"name":"Sentence Formation and Writing Style","type":"default","comments":[{"abbreviation":"Frag","comment":"*Revise Sentence Fragment:*\nThis sentence fragment is only part of a complete sentence.To fix a sentence fragment, try these ideas:\n*▪* Change the fragment into a complete thought by adding a subject or predicate. The subject of a sentence is the \"do-er.\" The predicate is what the \"do-er\" does.\n*Fragment Example:* Solved a problem with her quick thinking.\n*Revision:* _She_ (subject) solved a problem with her quick thinking.\n*Fragment Example:* Mainly the lack of time.\n*Revision:* Mainly, they _needed_ (predicate) more time.\n*▪* Connect the fragment to the sentence before or after.\n*Fragment Example:* Because of the ice. The roads were hazardous.\n*Revision:* The roads were a hazardous because of the ice.\n*▪* Read the sentence out loud. Unless it is a question, the voice naturally drops down at the end of a complete sentence.","id":"Frag0.092650967124138"},{"abbreviation":"Run-on","comment":"*Revise Sentence Run-on:*\nThis run-on incorrectly connects two independent clauses (a noun and connected verb which tells a complete thought). If connected with a comma, the run-on is known as a _comma splice._ To fix a sentence run-on, try these revision strategies:\n*▪* Separate the run-on into two sentences.\n*Run-on Example:* Lou told his mom he told his sister.\n*Revision:* Lou told his mom. He told his sister.\n*▪* Add a comma followed by a conjunction (_for, and, nor, but, or, yet, so_)between the two complete thoughts.\n*Run-on Example:* Lou told his mom he told his sister.\n*Revision:* Lou told his mom, and he told his sister.","id":"Run-on0.9448655240415296"},{"type":"text","abbreviation":"CmpltSub","comment":"*Revise with a Complete Subject:*\nWhen additional words help name or describe the simple subject and serve as the \"do-er\" of the sentence, this phrase is called a _complete subject._ When two sentences each have a description of the same subject, they can be combined and form one complete subject.\n*Example:* The _nurse_ assisted the patient. She is _skilled._\n*Revision:* The _skilled nurse_ assisted the patient.","id":"CmpltSub0.9716910266242891"},{"type":"text","abbreviation":"CompSub","comment":"*Revise with a Compound Subject:*\nCombine simple sentences by revising with a compound subject. When two or more connected nouns or pronouns serve as the \"do-ers\" of the sentence, these words form a _compound subject_. The conjunctions _and_ or _or_ connects them.\n*Example:* The _doctor_ assisted the patient. The _skilled nurse_ assisted the patient.\n*Revision:* Both the _doctor and the skilled nurse_ assisted the patient.","id":"CompSub0.6009890516150256"},{"type":"text","abbreviation":"CompPred","comment":"*Revise with a Compound Predicate:*\nCombine simple sentences by revising with a compound predicate (the main verb). When two or more connected verbs complete the actions of the sentence subjects, these words form a _compound predicate_. The conjunctions _and_ or _or_ connects the verbs.\n*Example:* Suzanne _prepared_ a fantastic dinner. She _served_ the dinner, too.\n*Revision:* Suzanne _prepared and served_ a fantastic dinner.","id":"CompPred0.10872846600117647"},{"abbreviation":"Compnd","comment":"*Combine into Compound Sentence:*\nCombine these short sentences into a compound sentence. A compound sentence has two independent clauses. An independent clause has a noun and a connected verb which tells a complete thought. Join the two independent clauses with a comma followed by a conjunction (_for, and, nor, but, or, yet, so_).\n*Example:* I like the way she talks. She likes my voice.\n*Revision:* I like the way she talks, and she likes my voice.\nAvoid placing two compound sentences next to each other in the same paragraph.","id":"Compnd0.2913806180447498"},{"type":"text","abbreviation":"Complex","comment":"*Combine into Complex Sentence:*\nCombine these short sentences into a complex sentence. A complex sentence has both an independent clause and a dependent clause. An independent clause has a noun and a connected verb which tells a complete thought. A dependent clause has a noun and a connected verb which does not tell a complete thought. The dependent clause can be placed at the beginning, in the middle, and at the end of sentences. Most dependent clauses begin with these words: _After,_ _Although,_ _As,_ _When,_ _While,_ _Until,_ _Because,_ _Before,_ _If,_ or _Since_. Together they create the *AAWWUBBIS Memory Trick*.\n*Example:* I finally left my home. I cried for days.\n*Revision:* _When_ I finally left home, I cried for days.\nAvoid placing two complex sentences next to each other in the same paragraph.","id":"Complex0.9045495646185822"},{"abbreviation":"MisSSub","comment":"*Misplaced Sentence Subject:*\nThe subject (the \"do-er\" of the sentence) is usually placed at or near the beginning of a declarative sentence before the predicate (the main verb).\n*Misplaced Sentence Subject Example:* Into the room went the _talkative friends_ to gossip.\n*Revision:*_The talkative friends_ went into the room to gossip.","id":"MisSSub0.35477828599242156"},{"type":"text","abbreviation":"MisQSub","comment":"*Misplaced Question Subject:*\nIn interrogative sentences (questions), the subject (the \"do-er\" of the sentence) is usually placed after the predicate (the main verb) or comes between the parts of the verb.\n*Misplaced Sentence Subject Examples:* Is the one you talked about she? Will know Tom what to do?\n*Examples:*_Is_ she the one you talked about? _Will Tom know_ what to do?\nSentVar\n*Needs Sentence Variety:*\nInstead of always beginning sentences with the subject (a noun or pronoun acting as the \"do-er\" of the sentence), use different parts of speech to add variety to your sentences.\n*Example:* They (subject) eat too many hamburgers.\n*Revisions:*\n*▪ Adjective* − _Too many_ hamburgers they eat.\nAn adjective modifies (describes, identifies, defines, or limits) a noun and answers Which one? How many? or What kind?\n*▪ Adverb* − _Often_, they eat too many hamburgers.\nAn adverb modifies (describes, identifies, defines, or limits) a verb and answers How? When? Where? or What Degree?\n*▪ Prepositional phrase* − _At home_ they eat too many hamburgers.\nA preposition shows a relationship between a word which signals location, position, or time and its object. The preposition asks \"What?\" or \"Whom?\" and the object follows with the answer.","id":"MisQSub0.37986503377893777"},{"type":"text","abbreviation":"Chron","comment":"*Rearrange in Chronological Order:*\n_Chronological_ refers to the order of time, from older events to newer ones. Use transition words such as _first_, _second_, _later_, _next_, _before_, _for one_, _for another_, _previously_, _then_, _finally_, _following_, _since_, and _now_ to establish a time sequence from old to new.\n*Example:* Mary asked if she could go with us, later she got permission from her parents, but before both she had cancelled her plans.\n*Revision:* First, Mary cancelled her plans. Then she asked if she could go with us. Later, she got permission from her parents.","id":"Chron0.8673432979849547"},{"type":"text","abbreviation":"Interpt","comment":"*Eliminate Sentence Interruption:*\nSentence interruptions can ruin the flow of a sentence. Rearrange the sentence or simply delete the interruptions.\n*Examples:* This was not a good idea, although I must admit I didn't have any better ones, and it was bound to fail.\n*Revision:* This was not a good idea and it was bound to fail, although I must admit I didn't have any better ones.","id":"Interpt0.09145152472028739"},{"abbreviation":"OffTop","comment":"*Off Topic:*\nThe focus of this section does not support the thesis statement. Consider eliminating this section, revising to better demonstrate how it provides support, or substituting with something else.\n*Example:* Baseball has been called a \"simple game\"; however, it does require skilled decision-making. Hot dogs always taste best at the ballpark (Off Topic).","id":"OffTop0.3141461131325345"},{"abbreviation":"Connect","comment":"*Needs Connection:*\nHow does this fit with other sections? Consider adding transitions or repeat wording to show relationships. Common relationships include cause and effect, comparison (same) and contrast (different), and problem to solution.","id":"Connect0.5097236360882165"},{"abbreviation":"Place","comment":"*Out of Place:*\nThis section seems out of place. Consider rearranging sentences or paragraphs.","id":"Place0.24299584894161996"},{"abbreviation":"NotClr","comment":"*Not Clear:*\nThis section is confusing and does not seem to fit with the rest. Provide an example, a definition, or more explanation to make it more understandable.\n*Example:* Many still farmed vegetable crops of which there were too many.\n*Revision:* Many farmers continued to grow vegetables, such as corn, when too much corn was already on the shelves of supermarkets.","id":"NotClr0.42544887244673535"},{"abbreviation":"Awk","comment":"*Awkward:*\nThe construction of this sentence makes it hard to follow. Consider revising the word order.\n*Example:* The call, made by the police, to carry out the proposed solution to the problem, was not carried out majority members of the community.\n*Revision:* Most people in the community did not do what the police suggested to solve the problem.","id":"Awk0.8080942165136391"},{"abbreviation":"Trans","comment":"*Needs Transition:*\nUse a transition word to help the reader understand the connection between or shift from one thought to another. Transitions may be placed at the beginning, middle, or end of sentences.\n*Examples:* _First_, she had practiced; however, she practiced incorrectly and _so_ was unsuccessful _for these reasons_.","id":"Trans0.7006288847938973"},{"type":"text","abbreviation":"GetSpf","comment":"*Get Specific:*\nThe concrete detail is too general. Substitute with more specific evidence or details to convince, inform, or explain. Choose among these types of evidence: *FE SCALE Evidence Strategies:* F̲act, E̲xample, S̲tatistic (a percentage), C̲omparison (the similarities and differences), Quote from an A̲uthority (an expert on the issue or topic), L̲ogic (what makes sense), or E̲xperience. Begin each concrete detail with a transition word.\n*Example:* Many people visit recreational areas.\n*Revision:* Close to 85% of Americans visited recreational areas, such as parks, beaches, and national forests this year (Matthews 34).","id":"GetSpf0.024220285792317497"},{"abbreviation":"NotCons","comment":"*Not Consistent:*\nThe content or tone of the argument or information has changed, is contradictory, or has been taken in a different direction than what has been said before. Revise to maintain consistent support of your thesis statement.\n*Example:* The math teacher was highly educated, yet she did not know much math.","id":"NotCons0.4489646886943739"},{"abbreviation":"Omission","comment":"*Something Missing:*\nIt seems that a word, key idea, information, or explanation is missing here. Re-read what you have written from the reader's point of view to to see what needs to be added.\n*Example:* The Folsom High School Band has the best band in the city.\n*Revision:* The Folsom High School Band has the only band in the city, but it is excellent.","id":"Omission0.27699615909130704"},{"abbreviation":"NotCorr","comment":"*Not Correct:*\nThis fact does not seem to be correct. Check your sources and revise as needed.\n*Example:* The earth is a sphere and completely flat.","id":"NotCorr0.19579792306771493"},{"abbreviation":"Seq","comment":"*Sequence Issue:*\nThis sentence is not in the right place and is confusing to the reader. Re-read the paragraph and revise or delete if it does not fit in to the order or flow of the paragraph.\n*Examples of Proper Sequence:* General to specific, first to last, cause to effect, problem to solution, old to new.","id":"Seq0.7524768953817431"},{"abbreviation":"PosSFrm","comment":"*Positive Sentence Formation Comment:*\nYour sentences are well-constructed and have plenty of variety.","id":"PosSFrm0.7872329033960062"},{"abbreviation":"PosWrSt","comment":"*Positive Writing Style Comment:*\nYou demonstrate that you know the purpose of the writing prompt (assignment) and the needs of your reader. Your writing style make your paper easy to read and understand. Sentences are in proper order and nicely transition from one to another.","id":"PosWrSt0.9060288587858052"}],"id":"Sentence Formation and Writing Style0.593472145187059"},{"name":"Word Choice","type":"default","comments":[{"abbreviation":"UnExpr","comment":"*Delete Unnecessary Words:*\nDelete words which do not add meaning to your sentences.\n*Examples:* I think, I believe, In my opinion, from this writer's point of view, at the end of the day, when all is said and done, in light of these facts","id":"UnExpr0.6705391885284544"},{"type":"text","abbreviation":"DbNeg","comment":"*Revise Double Negative:*\nDon't use double negatives in essays or reports.\n*Examples:* You should _not_ _fail_ to use soap to wash dishes. Don't not do that ever.\n*Revision:* Always use soap to wash dishes.","id":"DbNeg0.7111469369878363"},{"abbreviation":"Wordy","comment":"*Eliminate Wordiness:*\nThis section is longer than it needs to be. Consider deleting words, phrases, or clauses which interrupt the flow of your ideas, or consider re-wording−especially with stronger verbs and more specific nouns. Often, using clauses beginning with _who, whom, which,_ and _that_ and too many prepositional phrases create wordiness.\n*Example:* The girl, whom I used to consider as a friend, but left me to eat lunch alone, which was extremely mean in the cafeteria during lunch on Tuesday ignored me.\n*Revision:* The mean girl ignored me in the cafeteria last Tuesday.","id":"Wordy0.7782554452396386"},{"abbreviation":"To-beVb","comment":"*Revise Too Many \"to be\" Verbs:*\nLimit using so many \"to be\" verbs: _is, am, are, was, were, be, being, been_. To replace \"to be\" verbs: 1. *Substitute* a more active verb. 2. *Convert* one of the words in the sentence to a verb form. 3. *Change* the beginning of the sentence. 4. *Combine* the sentence which has the \"to be\" verb with the sentence before or after to use another stronger and specific verb.\n*Substitute Example:* The child _was_ sad.\n*Revision:* The child _felt_ sad.\n*Convert Example:* Charles Schulz _was_ the _creator_ of the _Peanuts_ cartoon strip.\n*Revision:* Charles Schulz _created_ the _Peanuts_ cartoon strip.\n*Change Example:* The run-away car _will be_ stopped by the tire spikes.\n*Revision:* The tire spikes will stop the run-away car.\n*Combine Example:* The child _is_ terrified. She _is_ feeling that way because of the news story.\n*Revision:* The news story terrified the child.","id":"To-beVb0.998565144181681"},{"abbreviation":"WC","comment":"*Change Word Choice:*\nThis word choice is incorrect, unclear, inappropriate, imprecise (not the exact meaning), or it may have a different connotation (an idea or feeling that the word suggests) than what you intend to say. To revise, either delete the word or use a thesaurus to substitute another word which fits better. Check its definition in a dictionary.\n*Example:* The _gigantic_ little rodent squeezed into its mouse hole.\n*Revision:* The little mouse squeezed into its mouse hole.","id":"WC0.7381044050821246"},{"abbreviation":"WordOrd","comment":"*Revise Word Order:*\nAdjectives are placed before nouns, and subjects before verbs, in sentences using the active voice. Place nouns which emphasize the main thought at the end of sentences.\n*Examples:* Both red and blue, chirped the birds. Birds seek freedom most of all.\n*Revisions:* The red and blue birds both chirped. What birds seek most of all is _freedom_.","id":"WordOrd0.07449165744103814"},{"abbreviation":"Rep","comment":"*Repeated Word:*\nThis word or phrase has been used too often. Use a pronoun or a synonym (a word which means the same) instead of repeating this word.\n*Example:* She carefully planned the party, being careful to listen to advice.\n*Revision:* She planned the party, being careful to listen to advice.","id":"Rep0.0792631784848592"},{"type":"text","abbreviation":"Vocab","comment":"*Revise Vocabulary:*\nThis word is too difficult or technical and it does not fit with the rest of your writing. Use a simple word to say what you mean that fits the rest of the sentence.\n*Example:* The children enjoy playing with their new canine.\n*Revision:* The children enjoy playing with their new dog.","id":"Vocab0.67473491089205"},{"abbreviation":"Def","comment":"*Needs Definition:*\nYour reader may not understand this word. Define the word or use surrounding context clues, such as synonyms, antonyms, and examples.\n*Example:* He promised _revisions_, because changes were necessary.","id":"Def0.22112315912478264"},{"abbreviation":"Slang","comment":"*Delete Slang:*\nDon't use slang in essays or reports. Slang is used with certain groups of people and in certain situations. It is more often used in conversation than in writing.\n*Example:* The _kids_ studied hard for their exams.\n*Revision:* The children studied hard for their exams.","id":"Slang0.755111257280709"},{"abbreviation":"Contrct","comment":"*Delete Contraction:*\nDon't use contractions in essays or reports. A contraction is a shortened form of one or two words (one of which is usually a verb). An apostrophe takes the place of a missing letter at the beginning, middle, or end of the word.\n*Examples:* They _shouldn't_ talk when they don't understand the subject.\n*Revision:* They should not talk when they do not understand the subject.","id":"Contrct0.09496651664581668"},{"abbreviation":"Abbr","comment":"*Delete Abbreviation:*\nDon't use abbreviations in essays or formal writing. An abbreviation uses a period to shorten a word or words.\n*Examples:* _So._ Dakota is in the _U.S._\n*Revision:* South Dakota is in the United States.","id":"Abbr0.4656869984290686"},{"abbreviation":"PosWC","comment":"*Positive Word Choice Comment:*\nAccurate and creative word choice are the keys to successful writing. You have taken the effort to select words which mean exactly what you want them to say.","id":"PosWC0.1090773886911891"}],"id":"Word Choice0.9897777224562285"},{"name":"Nouns, Pronouns, Adjectives","type":"default","comments":[{"abbreviation":"SpfNoun","comment":"*Use Specific Noun:*\nAvoid using general common nouns which do not use the senses (taste, touch, sound, sight, feeling). A common noun is an idea, person, place, or thing.\n*Example:* I read the _news_ about the _hunger problem_ in Africa. Instead, use specific, concrete nouns which can be perceived by senses.\n*Example:* I read the article in the _Sacramento Bee_ about the famine and mass starvation in Liberia, Africa.","id":"SpfNoun0.0949811286039135"},{"type":"text","abbreviation":"SubPro","comment":"*Needs Subject Case Pronoun:*\nRevise with a subject case pronoun. Use the subject case pronouns: _I, you, he, she,_ and _it_ (singular) or _we, you,_ and _they_ (plural) in place of the subject (the \"do-er\") of the sentence. A subject case pronoun that is part of a compound subject is placed last.\n*Examples:* Abel and _she_ attended the concert.\n*Substitution Trick:* Drop other nouns or pronouns in a compound subject to check if the remaining pronoun sounds right.\n*Example:* John and _I_ play video games. Drop and check ‒ _I_ play video games.","id":"SubPro0.4733031366899152"},{"type":"text","abbreviation":"ObjPro","comment":"*Needs Object Case Pronoun:*\nRevise with an object case pronoun. Use the object case pronouns: _me, you, him, her, it_ (singular) or _us, you_,and _them_ (plural) in these ways:\n*▪* A direct object, answering What? or Whom? in response to the verb.\n*Example:* She hit _him_.\n*▪* Place the object case pronoun last in compound objects.\n*Example:* The friend gave Kathy and _us_ a bag of chips.\n*Substitution Trick:* Drop other nouns or pronouns in a compound object to check if the remaining pronoun sounds right.\n*Example:* She gave it to John and _me_ or _I_. Drop and check ‒ She gave it to _me_, not _I_.\n*▪* As the object of a prepositional phrase. The preposition shows a relationship between a word which signals location, position, or time and its object. The preposition asks \"What?\" or \"Whom?\" and the object follows with the answer.\n*Example:* They smiled at _me_.\n*▪* An indirect object, answering For What? or For Whom? in response to the verb. The indirect object is usually placed before the direct object in a sentence.\n*Example:* He gave _her_ a pen.","id":"ObjPro0.6140714866509374"},{"abbreviation":"ProRe-st","comment":"*Pronoun Re-statement Error:*\nDon't restate the subject twice with a pronoun in the same sentence. The subject is the \"do-er\" of the sentence.\n*Examples:* That dog, which is friendly, _he_ was easy to train.\n*Revision:* That dog, who is friendly, was easy to train.","id":"ProRe-st0.11882650593672972"},{"type":"text","abbreviation":"ProAnt","comment":"*Revise Pronoun Antecedent Issue:*\nAn antecedent is the word or group of words to which a pronoun refers. Use these revision strategies to make the clear the connection between the pronoun and its antecedent:\n*▪* Place the pronoun close to its antecedent.\n*Example:* _John_, just like Peter, enjoyed _his_ sports.\n*Revision:* _John_ enjoyed _his_ sports, just like Peter.\n*▪* Change either the pronoun or antecedent to be more specific.\n*Example:* He gave _the dog his bone_.\n*Revision:* He gave _Fido the dog bone_.\n*▪* Don't use a pronoun that refers to the object of a preposition. The preposition shows a relationship between a word which signals location, position, or time and its object. The preposition asks \"What?\" or \"Whom?\" and the object follows with the answer.\n*Example:* In Twain's _Tom Sawyer_, _he_ uses political humor.\n*Revision:* Twain uses political humor in _Tom Sawyer_.","id":"ProAnt0.9640369962794557"},{"type":"text","abbreviation":"RelPro","comment":"*Correct Relative Pronoun:*\nYou used the wrong relative pronoun. Of the relative pronouns: _that_, _which_, _who_, _whom_, and _whose_, the pronoun _that_ can refer to people or things in general. Use _which_ for specific things and _who, whom,_ and _whose_ for specific people, animals, and characters.\n*Who and Whom Trick:* _Who_ is in the subject case and acts upon a verb. Substitute _he_ or _they_, rearrange the sentence to make sense,and check if it sounds right. _Whom_ is in the object case and receives the action of the verb. Substitute _him_ or _them_ and check if it sounds right.\n*Example:* She knows _whom_ she should ask. Substitute, rearrange, and check: She knows she should ask _him. Him_ sounds right, so _whom_ is correct.","id":"RelPro0.8665648947772915"},{"abbreviation":"TTTT","comment":"*Correct This, That, These, or Those:*\nThe words, _this_ and _these_, refer to nouns or pronouns close to the writer, while _that_ and _those_ refer to nouns or pronouns away from the speaker or writer.\n*Examples:* _This_ right here and _that_ by the window are heavier than _these_ desks in front of me and _those_ tables by the door.","id":"TTTT0.67202192874838"},{"type":"text","abbreviation":"PossPro","comment":"*Correct Possessive Pronoun:*\nThe possessive pronouns: _my, our, your,_ _his_, _her_, _its_ and _their_ must connect to nouns. They are called _determiners_, because they determine _whom_ belongs to the noun.\n*Example:* _Your_ friend. _Your_ determines whose friend it is.\nOther possessive pronouns: _mine, ours, yours,_ _his_, _hers_, and _theirs_ stand on their own and do not connect to nouns.\n*Example:* The pillow is _mine._","id":"PossPro0.2036456195577696"},{"abbreviation":"RefPro","comment":"*Correct Reflexive Pronoun:*\nReflexive pronouns end in \"self\" or \"selves\" and must refer to the subject (the \"do-er\") of the sentence. These pronouns are necessary to the meaning of the sentence: _myself_, _ourselves_, _yourself_, _yourselves_, _himself_, _herself_, _itself_, and _themselves_.\n*▪* Don't use a reflexive pronoun as the subject.\n*Examples:* Joe and _myself_ are playing cards.\n*Revision:* Joe and _I_ are playing cards.\n*▪* Don't use an object case pronoun (_me, you, him, her, it_, _us, you_, _them_) as a reflexive pronoun.\n*Example:* I got me a sandwich.\n*Revision:* I got myself a sandwich. I got a sandwich.","id":"RefPro0.4210898277427031"},{"abbreviation":"IntPro","comment":"*Correct Intensive Pronoun:*\nIntensive pronouns (_myself_, _ourselves_, _yourself_, _yourselves_, _himself_, _herself_, _itself_, and _themselves_) follow a noun or pronoun to add emphasis. They are unnecessary to the meaning of the sentence. Never use _ownself (as in my ownself), ourself,_ or _hisself, and don't use commas before or after the intensive pronoun._\n*Example:* He won _hisself_ the game.\n*Revision:* He _himself_ won the game.","id":"IntPro0.41398292182793983"},{"abbreviation":"Gender","comment":"*Revise Gender Pronoun Issue:*\nMake both the pronoun and its antecedent (the word or group of words to which a pronoun refers) plural when gender (male or female) does not need to be identified.\n*Example:* _Everyone_ needs _his_ rest.\n*Revision:* _All_ need _their_ rest.","id":"Gender0.9597088059403727"},{"abbreviation":"AdjOrd","comment":"*Revise Adjective Order:*\nAn adjective is placed before the noun it modifies (describes, identifies, defines, or limits) and answers Which one? How many? or What kind? of the noun. Avoid using adjectives that do not add meaning to a sentence, such as _interesting_, _beautiful_, _nice_, and _exciting_. Multiple adjective follow the Which one? How many? or What kind? order.\n*Examples:* She saw _these_ (Which one?) _two_ (How many?) _handsome_ (What kind?) men.","id":"AdjOrd0.030562234822484102"},{"abbreviation":"Article","comment":"*Correct Article:*\nAn article (_a_, _an_, _the_) is an adjective used before a noun or other adjective. The _a_ comes before a consonant sound; the _an_ comes before a vowel sound.Both _a_ and _an_ refer to unspecific things, while _the_ is specific.\n*Examples:* He wanted _an_ egg or _a_ tomato, but I gave him _the_ toast.","id":"Article0.35487564310606023"},{"abbreviation":"Partcpl","comment":"*Correct Participle:*\nA participle is a verb form that serves as an adjective. Present participles end in __ing_.\n*Example:* I hear _running_ water. Past participles end in __d_, __ed_, or __en_; however, some have irregular forms, many of which end in __t_.\n*Examples:* said,frightened, given, built","id":"Partcpl0.8644469381679865"}],"id":"Nouns, Pronouns, Adjectives0.464796941225492"},{"name":"Verbs","type":"default","comments":[{"type":"text","abbreviation":"SpfVb","comment":"*Correct Noun Subject-Verb Agreement:*\nThe verb does not match the subject noun (the \"do-er\" of the sentence). Follow these rules to match a verb to its noun subject:\n*▪* A singular noun subject makes the main verb end in s. A plural noun subject makes the main verb not end in s.\n*Examples:* John walks. John and Marci walk. The children walk.\n*▪* If matching a verb to a compound subject (two or more \"do-ers\" of the sentence) which does not include _and_, match the verb to the last noun in the compound subject.\n*Examples:* The tigers or the _lion_ _roars_ each day. Neither Tom _nor_ Elena _swims_.\n*▪* Collective nouns that refer to a group of individuals are usually singular.\n*Examples:* The _team works_ together, but the _class does_ not.\n*How to Identify the Subject:* To identify the subject noun, first eliminate all prepositional phrases and dependent clauses. Next, look for the main verb and then ask \"Who?\" or \"What?\" The answer is the subject.\n*Example:* The _flavors_ -of his snow cones- (prepositional phrase) -which he developed last summer-, (dependent clause) _excite_ my taste buds. The main verb is _excite._ \"Who?\" or \"What?\" The answer is the subject: _flavors._ Because _flavors_ is a plural subject, it determines that the verb, _excite_, must not end in s.","id":"SpfVb0.1352831894563229"},{"type":"text","abbreviation":"ProSV","comment":"*Correct Pronoun* *Subject-Verb Agreement:*\nThe verb does not match the subject pronoun (the \"do-er\" of the sentence). Follow these rules to match a verb to its pronoun subject:\n*▪* A singular pronoun subject makes the main verb end in s. A plural pronoun subject makes the main verb not end in s.\n*Examples:* He walks. John and she walk. They walk.\n*▪* The subject case pronouns: _I, we,_ and _you_ match verbs that do not end in s.\n*Examples:* I _like_ it; we _love_ it; but you _hate_ it.\n*▪* The subject case pronouns: _he, she, it,_ and _they_ match verbs that do end in s.\n*Examples:* He _likes_ it; she _loves_ it. It _pleases_ everyone and they _ask_ for it.\n*▪* An indefinite singular pronoun matches a verb that ends in s.\n*Examples:* Anybody, Anyone, Anything, Each, Either, Everybody, Everyone, Everything, Neither, Nobody, Nothing, No one, One, Somebody, Someone, Something _seems_ loud, not _seem_ loud.\n*▪* An indefinite plural pronoun matches a verb that does not end in s.\n*Examples:* Both, Few, Many, Several _grow_ quickly, not _grows_ quickly.\n*▪* Indefinite number pronouns: _all_, _any_, _half_, _more_, _most_, _none_, _other_, and _some_ may be singular or plural depending upon the surrounding word clues.\n*Examples:* _None_ of _this helps,_ but _more_ of _these types may_ do so.","id":"ProSV0.5552756124152105"},{"type":"text","abbreviation":"HelpVb","comment":"*Correct Helping Verb:*\nHelping verbs are added before verbs to indicate present or past tense. They suggest an ongoing action, not a one-time event. Use the proper form of these verbs:\n*▪* The \"to do\" verbs: _do_, _does_, and _did_ connect to infinitives (base forms of the verbs). \n*Examples:* They _do_ help; Marta _does_ help; Jaime and Luis _did_ help.\n*▪* The \"to have\" verbs: _have_, _has_, and _had_ suggest an ongoing action for a specific amount of time and connect to past participles (verb forms ending in __d_, __ed_, or __en_ and irregular forms, many of which end in __t_).\n*Examples:* They _have_ said; Marta _has_ frightened; Jaime and Luis _had_ given\n*▪* The \"to be\" verbs: _is, am, are, was, be, being,_ and _been_ connect to present participles (verb forms ending __ing_).\n*Examples:* They _are_ helping; Marta _is_ helping; Jaime and Luis _were_ helping.","id":"HelpVb0.012851916161626509"},{"type":"text","abbreviation":"Modal","comment":"*Correct Modal:*\nModals are verbs which are added before infinitives (base forms of the verbs) to show a condition in which there are different possibilities. The modals: _can_, _could_, _may_, _might_, _must_, _shall_, _should_, _will_, and _would_ do not change the tense of the verb.\n*Examples:* They _could_ help (not _helped_) the teacher if they wanted.\nModals are often placed before helping verbs, in which case the \"to have\" and \"to be\" verbs do change the verb endings.\n*Examples:* They _could_ have helped the teacher if they _would_ have been listening.\nDon't substitute _of_ for the _have_ after a modal.\n*Example:* They should _of_ have helped.\n*Revision:* They should _have_ helped.","id":"Modal0.5559583917488811"},{"type":"text","abbreviation":"LinkVb","comment":"*Correct Linking Verb:*\nA linking verb follows a subject (the \"do-er\" of the sentence) and links to another word which it modifies (describe, identify, define, or limit). Linking verbs include the \"to be\" verbs: _is_, _am_, _are_, _was_, _were_, _be_, _being_, _been_ and _become_, _feel_, _look_, _seem_, _smell_, _sound_, _taste_.\n*Example:* Lori _is_ strong.\n*▪* Don't substitute *be* or *been* for *is* or *was*.\n*Example*: He _be_ funny.\nDon't use the non-standard use of the \"do be\" or \"don't be\" patterns.\n*Examples:* _Do be_ listening and _don't be_ talking.\n*▪* Don't use the non-standard _was_ and _were_.\n*Examples:* We was friends and it were nice.\n*Revision:* We were friends and it was nice.\n*▪* Don't drop linking verbs.\n*Examples:* She nice, but I been nice to her first.\n*Revision:* She is (was) nice, but I had been nice to her first.","id":"LinkVb0.7561709045205973"},{"abbreviation":"TransVb","comment":"*Transitive Verb Error:*\nThis transitive verb needs an object. A transitive verbis a mental or physical action that acts upon a direct object. The direct object answers _Whom_? or _What_? from the verb.\n*Example:* Lewis _gave_ (transitive verb) a wonderful gift (direct object).\nAn intransitive verb is a mental or physical action that acts without an object. Linking verbs are all intransitive verbs.\n*Example:* The baby _screams_ (intransitive verb) loudly.","id":"TransVb0.8825374460629836"},{"type":"text","abbreviation":"VT","comment":"*Correct Verb Tense:*\nDon't mix verb tenses. English has three basic verb tenses to show time.\n*▪* The past verb tense adds \"_d\" or \"_ed\" at the end of the infinitive (base form of the verb) and does the past physical or mental action of the subject (the \"doer\" of the sentence). These actions are one-time events that took place at a specific time.\n*Examples:* I _asked_ for it. You _appeared_ interested.\n*▪* The present tense does the present physical or mental action. The present verb tense is the infinitive (base form of the verb). A singular subject makes the present tense verb end in s (except _I, we,_ and _you_), but a plural subject matches a verb which does not end in s.\n*Examples:* He _swims_. Mandy and Mark _swim_.\n*▪* The future tense is formed with _will_ or _shall_ + the infinitive (base form of the verb) to describe a physical or mental action in the future.Traditionally, _shall_ has been used to match the _I_ and _we_ pronouns.\n*Examples:* You _will_ stay, but I _shall_ go.\nPast, present, and future verb tenses are also determined by helping verbs: _did_ and _had_ (past)_, do, does,_ _have,_ and _has_ (present), _will_ _do,_ _will have,_ and _shall_(future) and the \"to be\" verbs: _was,_ _were,_ and _been_ (past), _is, am, be,_ and _are_ (present), and _will be_ and _shall be_ (future).","id":"VT0.8298048917633036"},{"type":"text","abbreviation":"IrrgVb","comment":"*Correct Irregular Verb:*\nAn irregular verb does not end in __d_, __ed,_ or __en_. The most frequent irregular verb ending is __t_.\n*Examples:* bent, bit, bought, felt, fought, got, kept, left, sent, shot, wrote","id":"IrrgVb0.39313963854369316"},{"type":"text","abbreviation":"PstProg","comment":"*Correct Past Progressive Verb:*\nThe past progressive is a verb form that adds an __ing_ onto the infinitive (base form of the verb) and is placed after a past tense \"to be\" verb: _was,_ _were,_ or _been_ to describe an ongoing past action. Frequently, the word _while_ is used in connection with the past progressive.\n*Example:* I _was day-dreaming_ while you talked.","id":"PstProg0.27080130092821864"},{"abbreviation":"PrProg","comment":"*Correct Present Progressive Verb Form:*\nThe present progressive is a verb formthat adds an __ing_ onto the infinitive (base form of the verb) and is placed after a present tense \"to be\" verb: _is, am, be,_ or _are_ to describe an ongoing action happening or existing now.\n*Example:* I _am walking_ to the store. Some verbs can't use the present progressive form: to be, to belong, to care, to cost, to exist, to envy, to fear, to hate, to like, to love, to mind, to need, to owe, to want.\n*Example:* I _be fearing_ it.\n*Revision:* I _fear_ it.","id":"PrProg0.16451883870842954"},{"abbreviation":"FutProg","comment":"*Correct Future Progressive Verb:*\nThe future progressive is a verb formthat adds an __ing_ onto the infinitive (base form of the verb) and is placed after a _will_ or _shall_ + _be_ to describe an ongoing action that will take place over a period of time in the future (while another action takes place) or to describe an ongoing future action that will be briefly interrupted by an action of less importance.\n*Examples:* We will be eating while we play cards.The varsity will be playing after the junior varsity.","id":"FutProg0.31407895645246353"}],"id":"Verbs0.015237697145185969"},{"name":"Modifiers, Adverbs, Prepositions, Conjunctions","type":"default","comments":[{"type":"text","abbreviation":"CompMod","comment":"*Correct Comparative Modifier:*\nA comparative modifier is an adjective or adverb that modifies two things. Follow these rules to use comparative modifiers correctly:\n*▪* Use the suffix \"_er\" for a one-syllable modifier.\n*Example:* She is _short-er_ than I.\n*▪* Use \" ̲er\" or _more_ (_less_) for a two-syllable modifier.\n*Example:* He seems _more help-ful_ than they.\n*▪* Use _more_ or _less_ for a three-syllable (or longer) modifier.\n*Example:* Frank was _more gen-er-ous_ than Keith.\n*Example:* Frank was _more gen-er-ous_ than Keith.\n*▪* Use _more_ or _less_ for all adverbs ending in \"_ly.\"\n*Examples:* She apologized _more con-vin-cing-ly_ than did her friend.","id":"CompMod0.6619721441778585"},{"type":"text","abbreviation":"SupMod","comment":"*Correct Superlative Modifier:*\nA superlative modifier is an adjective or adverb that modifies three or more things Follow these rules to use superlative modifiers correctly:\n*▪* Use the suffix \"_est\" for a one-syllable modifier.\n*Example:* Of Rachel, Tim, and Sam, Rachel is the _smart-est_.\n*▪* Use \" ̲est,\" _most_, or _least_ for a two-syllable modifier.\n*Example:* Of Rachel, Tim, and Sam, Rachel has the _most tal-ent_).\n*▪* Use _most (least)_ for a three-syllable or longer modifier.\n*Example:* Of the five contestants, Jane spoke _most care-ful-ly_.","id":"SupMod0.4704671508526308"},{"type":"text","abbreviation":"MisMod","comment":"*Revise Misplaced Modifier:*\nThis modifier is misplaced. A modifier should be placed, whenever possible, next to the word it modifies (describes, identifies, defines, or limits).\n*Example:* The modifier in the following sentences is _only_: She _only_ requested two appetizers. *Revision:* She requested _only_ two appetizers.","id":"MisMod0.20504187302594756"},{"abbreviation":"AdvOrd","comment":"*Revise Adverb Order:*\nAn adverb modifies (describes, identifies, defines, or limits) a verb by answering How? When? Where? or What Degree? The adverb may be found before or after the word or words that it modifies (describes, identifies, defines, or limits). Follow these rules to use adverbs correctly:\nMultiple adverbs follow the How? When? Where? or What Degree? order.\n*Examples:* _Carefully_, you _soon_ may walk _where_ tigers _mostly_ roam.","id":"AdvOrd0.38545622612663943"},{"abbreviation":"Prep","comment":"*Revise Preposition Issue:*\nA preposition is always part of a prepositional phrase. The preposition shows a relationship between a word which signals location, position, or time and its object. The preposition asks \"What?\" or \"Whom?\" and the object follows with the answer.\n*Example:* He ran _up the road_.\n*Explanation:* The preposition, _up_, asks, \"What?\" and the object, _the road_, provides the answer. Follow these rules to use prepositions properly:\n*▪* Don't string together more than two prepositional phrases.\n*Example:* Peter Rabbit ran _through the field, under the fence, into the garden_.\n*Revision:* Peter Rabbit ran _through the field_. Afterwards, he ran _under the fence_ and _into the garden_.\n*▪* Don't add the _of_ or _on_ prepositions when unnecessary.\n*Examples*: Get off -of- my couch. Don't blame -on- me for that.\n*▪* Avoid ending sentences with awkward prepositions.\n*Example:* The cook did not know what the pie was made of.\n*Revision:* The cook did not know the ingredients in the pie.","id":"Prep0.35415137394986806"},{"abbreviation":"CoConj","comment":"*Needs Coordinating Conjunction:*\nCoordinating conjunctions join words or groups of words of equal importance.\n*Examples:* I need one _or_ two. He also brought along two water bottles, _yet_ he did not know why.\n*Memory Trick to remember the coordinating conjunctions:* *FANBOYS* (For-And-Nor-But-Or-Yet-So)","id":"CoConj0.6788861257074321"},{"abbreviation":"NoCoConj","comment":"*Coordinating Conjunction Error:*\nDon't start sentences with coordinating conjunctions.Avoid beginning sentences with the coordinating conjunctions *(FANBOYS*: For-And-Nor-But-Or-Yet-So*)* unless you finish the thought.","id":"NoCoConj0.9787328308095105"},{"abbreviation":"CorConj","comment":"*Needs Correlative Conjunction:*\nCorrelative conjunctions are pairs of conjunctions which join words or groups of words. The pairs include _both-and_, _not only-but also_, _either-or_, _whether-or_, _neither-nor_.\n*Example:* Both Jake _and_ Kenny went to college.","id":"CorConj0.682057973867283"},{"type":"text","abbreviation":"SubConj","comment":"*Needs Subordinating Conjunction:*\nA subordinating conjunction begins a dependent clause. A dependent clause includes a noun and connected verb, but it does not tell a complete thought. The subordinating conjunction signals time (_when_), cause-effect (_if_), or exception (_although_).\n*Time Example:* _While_ we waited, we played cards.\n*Cause-Effect Example:* I never knew, _because_ you hid it from me, that you broke the chair.\n*Exception Example:* I can't help _although_ he did.\n*AAWWUBBIS Memory Trick* *(to remember the subordinating conjunctions):* Most dependent clauses begin with these words: _After,_ _Although,_ _As,_ _When,_ _While,_ _Until,_ _Because,_ _Before,_ _If,_ or _Since_.","id":"SubConj0.9596627511659401"}],"id":"Modifiers, Adverbs, Prepositions, Conjunctions0.14006132710635777"},{"name":"Punctuation, Capitalization, Quotation Rules","type":"default","comments":[{"type":"text","abbreviation":"SpTagCm","comment":"*Correct Speaker Tag Comma:*\nFollow these rules for comma placement with speaker tags (the speakers and speech-related verbs) in dialogue:\n*▪* Place commas after a beginning speaker tag to the left of the quotation marks.\n*Example:* He said, \"I shouldn't listen to what you say.\"\n*▪* Place commas before and after a middle speaker tag to the left of both quotation marks.\n*Example:* \"But if you don't, he shouted \"you will never win.\"\n*▪* Place commas before an ending speaker tag to the left of the quotation marks.\n*Example:* \"Okay. I will give you another chance,\" he responded.\nQuestion marks and exclamation points are placed in the same positions as commas.","id":"SpTagCm0.6655124357930968"},{"abbreviation":"DrAddCm","comment":"*Correct Direct Address Comma:*\nFollow these rules for comma placement with nouns of direct address (the character spoken to) in dialogue:\n*▪* If the noun of direct address is placed at the beginning of the sentence, place a comma after that noun.\n*Examples:* Kristen, leave some for your sister. Officer Daniels, I need your help.\n*▪* If the noun of direct address is placed in the middle of the sentence, place commas before and after that noun.\n*Examples:* If you insist, Dad, I will. If you insist, Your Honor, I will.\n*▪* If the noun of direct address is placed at the end of the sentence, place a comma before that noun.\n*Examples:* Just leave a little bit, honey. Just leave a little bit, you selfish monster.","id":"DrAddCm0.8305986576329074"},{"abbreviation":"SerCm","comment":"*Correct Commas in Series:*\nPlace commas after each item in lists, except the last one. Newspapers, web articles, and some magazines eliminate the last comma; however, most style manuals still require the last comma.\n*Example:* John, Jane, and Jose left early.","id":"SerCm0.7546356617584333"},{"abbreviation":"IntroCm","comment":"*Needs Introductory Word or Words Comma:*\nPlace commas after introductory words or phrases which have special emphasis. Place a comma after introductory prepositional phrases with more than four words.\n*Examples:* _First_, listen to me. _Throughout the rest of the book_, the characters do not change. _From there_ they went to the party.","id":"IntroCm0.1706645778567042"},{"type":"text","abbreviation":"GeogCm","comment":"*Correct Comma with Geography:*\nPlace commas between geographical place names and after the last place name unless it appears the end of a sentence. When the place name is a possessive (shows ownership), this rule does not apply.\n*Examples:* She lived in Rome, Italy, for a year. Rome, Italy's traffic is congested.","id":"GeogCm0.7850577991459318"},{"abbreviation":"DatesCm","comment":"*Correct Comma with Dates:*\nPlace commas between the number date and its year and after the year unless it appears at the end of the sentence.\n*Example:* We left town on May 4, 1999, before the storm arrived.","id":"DatesCm0.2692817038168078"},{"abbreviation":"AdjCm","comment":"*Correct Commas with Adjectives:*\nPlace commas to separate coordinate adjectives. Coordinate adjectives are two or more adjectives that modify (describe, identify, define, or limit) a noun or pronoun in the same way. If you can add _and_ between the adjectives and reverse their order, commas must separate them.\n*Examples:* A friendly, kind man visited us.\n*Explanation:* A friendly _and_ kind man. A kind, friendly man. Both make sense, so commas are required between the coordinate adjectives.\nDon't use commas to separate cumulative adjectives. Cumulative adjectives are two or more adjectives that modify (describe) a noun or pronoun in different ways. If you can't add _and_ between the adjectives and reverse their order, don't separate them with commas.\n*Examples:* It's a big green bug.\n*Explanation:* It's a big _and_ green bug. It's a green big bug. Neither makes sense, so don't use commas between the cumulative adjectives.","id":"AdjCm0.06347198605701121"},{"abbreviation":"CompCm","comment":"*Correct Comma with Compound Sentence:*\nPlace commas before coordinating conjunctions (_for, and, nor, but, or, yet, so_) to join two long independent clauses. An independent clause is a noun and connected verb which tells a complete thought. If one or both of the independent clauses is less than five words, no comma is necessary.\n*Examples:* I liked her so much, _and_ she liked me more than I thought. I love him and he loves me.\n*▪* Don't join two independent clauses with a comma. This is known as a _comma splice._\n*Example:* They say they know what they are doing, they really have no idea how to proceed. *Revision:* They say they know what they are doing, but they really have no idea how to proceed.\n*▪* Use commas before the second of the paired correlative conjunctions to join two independent clauses.\n*Example:* _Either_ he must go, _or_ you must go.","id":"CompCm0.43550327218889895"},{"abbreviation":"DepClCm","comment":"*Correct Comma with Dependent Clause:*\nA dependent clause includes a noun and connected verb, but it does not tell a complete thought. Follow these rules to place commas with dependent clauses:\n*▪* If a dependent clause begins a sentence, place a comma after the clause.\n*Example:* _When he asked me_, I told him.\n*▪* If the dependent clause is in the middle of the sentence, place commas before and after the clause.\n*Example:* Jonna was sure, _since she had checked_, that she had turned the lights off.\n*▪* If a dependent clause ends the sentence, don't begin with a comma.\n*Example:* She left _after I did_.\n*▪* Place commas before and after (unless it ends the sentence) a dependent clause that begins with _which_, _who_, _whom_, or _whose_ if it simply adds information and doesn't limit the meaning of the connected independent clause (a noun and connected verb which tells a complete thought).\n*Example:* The jacket, _which mom wore yesterday_, was green.\n*▪* Don't use commas before and after (unless it ends the sentence) a dependent clause that begins with _which that_, _who_, _whom_, or _whose_ if it limits the meaning of the connected independent clause (a noun and connected verb which tells a complete thought).\n*Example:* The student _who wins the most votes_ will be elected Student Council President.","id":"DepClCm0.8140328746064658"},{"abbreviation":"InterCm","comment":"*Correct Commas with Sentence Interruptions:*\nPlace commas before and after words that interrupt the flow of the sentence.\n*Example:* The best way to see the game, _if you can afford it_, is in person.\nIf a word or group of words is placed after a noun or pronoun to identify, define, or describe it, place commas before and after the word or words unless it ends the sentence.\n*Example:* That man, _the one with the hat_, left town quickly.","id":"InterCm0.44066820286149544"},{"abbreviation":"ExclPnt","comment":"*Correct Exclamation Point:*\nUse one exclamation point to show strong emotion or surprise at the end of intentional fragments (parts of sentences) and exclamatory sentences. Don't use exclamation points in essays or reports.\n*Examples:* Wow! How amazing! The decision really shocked me!","id":"ExclPnt0.6778125824323848"},{"type":"text","abbreviation":"SgPossAp","comment":"*Correct Apostrophe with a Singular Possessive Noun:*\nA possessiveis a noun or pronoun that serves as an adjective to show ownership. Follow these rules to use singular possessives properly:\n*▪* When ending in an s having a /z/ sound, place an apostrophe, then an s, or simply end with an apostrophe.\n*Examples:* _Charles's_ friend or _Charles'_ friend is fun.\n*▪* A singular possessive noun can connect to gerunds(verb forms ending in \"ing\" that serve as sentence subjects).\n*Example:* _Joe's cooking_ is not the best.\n*▪* Place the apostrophe before the s for singular indefinite pronouns used as possessives.\n*Examples:* Now it is _anybody's_, _everybody's_, _somebody's_, _somebody else's_, _either's_ ballgame.\n*▪* Don't use an apostrophe with a possessive pronoun (yours, his, hers, ours, yours, its, theirs).\n*Examples:* That plate is _your's_.\n*Revision:* That plate is _yours_.","id":"SgPossAp0.9216805951321971"},{"abbreviation":"PlPossAp","comment":"*Correct Apostrophe with a Plural Possessive Noun:*\nA possessiveis a noun or pronoun that serves as an adjective to show ownership. Follow these rules to use plural possessives properly.\n*▪* For a plural possessive of a singular word that doesn't end in s, place the apostrophe after the s. If the singular and plural forms are spelled differently, place the apostrophe before the s.\n*Examples:* The _girls'_ team is good, but the _women's_ team isn't.\n*▪* For a plural possessive of a singular word that does end in s, add \"es\" and then the apostrophe.\n*Example:* Our stove worked better than the _Thomases'_ stove.","id":"PlPossAp0.9999349981335115"},{"abbreviation":"(Par)","comment":"*Correct Parentheses:*\nUse parentheses following words to identify, explain, or define the word or words before the parentheses.\n*Examples:* That shade of lipstick (the red) goes perfectly with her hair color.\nEnding punctuation is placed outside of words or phrases within parentheses, but inside when the parenthetical remark stands on its own as a complete sentence.\n*Examples:* I want that Popsicle® (the orange one). He was crazy. (He didn't even know what day it was.)","id":"(Par)0.36686483485789045"},{"abbreviation":"PplCap","comment":"*Correct People and Character Capitalization:*\nCapitalize people's and characters' names. Also, capitalize people's titles, such as _The President of the United States_ or _Alexander the Great._ Do not capitalize an article (_a_, _an_, _the_) that is part of the title unless it begins the title.\n*Examples:* Peter the Great, Cherokees, Donald Duck","id":"PplCap0.29148875575304456"},{"abbreviation":"PlaceCap","comment":"*Correct Place Capitalization:*\nCapitalize place names. Do not capitalize a preposition that is part of a title unless it begins the title. A preposition shows a relationship between a word which signals location, position, or time and its object. The preposition asks \"What?\" or \"Whom?\" and the object follows with the answer.\n*Examples:* Stratford upon Avon, Cardiff by the Sea, South Central Los Angeles, the West*,* Holocaust Museum.","id":"PlaceCap0.38223379416696446"},{"type":"text","abbreviation":"HolCap","comment":"*Correct Holiday* *Capitalization:*\nCapitalize holidays. Normally, it is proper form to spell out numbers from one through ten in writing. However, when used as a date name, the numerical number is used.\n*Example:* They celebrate the _4th_ _of July_, but not Easter.","id":"HolCap0.019459746658575083"},{"abbreviation":"TitThCap","comment":"*Correct Titles of Things Capitalization:*\nCapitalize the words in titles. Don't capitalize articles (a, an, the), conjunctions (and), or prepositions (with) unless these words begin or end the title.\n*Examples:* My favorite song is \"The End.\" I like the movie _Gone with the Wind_. She joined the Federal Bureau of Investigation.","id":"TitThCap0.4168781114748741"},{"abbreviation":"BusCap","comment":"*Correct Business Capitalization:*\nCapitalize the names of businesses.\n*Examples:* McDonald's provided money for our school uniforms and so did Google.","id":"BusCap0.6354646444927914"},{"abbreviation":"LangCap","comment":"*Correct Language Capitalization:*\nCapitalize the names of languages and dialects (different forms of a language).\n*Examples:* He spoke Spanish with a Castilian dialect.","id":"LangCap0.08810649747289356"},{"abbreviation":"EventCap","comment":"*Correct Event Capitalization:*\nCapitalize the names of special events.\n*Examples:* The New Year's Day Parade was fun, but the Mardi Gras was even better.","id":"EventCap0.5941065755704245"},{"abbreviation":"HistCap","comment":"*Correct Historical Period Capitalization:*\nCapitalize named historical periods. Leave articles, conjunctions, and prepositions in lower case, unless they begin or end the historical period.\n*Examples:* My favorite historical periods are Ancient History and the Age of Reason.","id":"HistCap0.9256602983826829"},{"abbreviation":"TimeCap","comment":"*Correct Time Capitalization:*\nCapitalize the names of special periods of time. Leave articles, conjunctions, and prepositions in lower case unless they begin or end the time period.\n*Example:* Year of the Dog.\nHowever, use lower case and periods for \"a.m.\" and \"p.m.\" and for seasons.\n*Examples:* Change your clock from 11:00 p.m. to 12:00 a.m. this spring.","id":"TimeCap0.142921485228658"},{"abbreviation":"TitPCap","comment":"*Correct Title of Person Capitalization:*\nCapitalize the title of a person when it is connected to the name. Don't capitalize the title if it is not connected to the name.\n*Examples:* I heard Mayor Johnson, Ms. Yates, John Doe, Jr., and Dr. Rodriguez ask questions of the senator.","id":"TitPCap0.7475038129825768"},{"abbreviation":"Titles","comment":"*Correct Title Punctuation:*\nAs a general rule, use quotation marks before and after titles of short texts; titles which are parts of a whole; or titles of things that cannot be picked up from a desk.\n*Examples:* articles, television episodes, acts in a play, videos, short stories, reports.\nAs a general rule, use italics for titles of long texts; titles of whole things; or titles of things that can be picked up from a desk.\n*Examples:* magazines, newspapers, long narrative poems, movies, albums, television shows, plays","id":"Titles0.21557434503714634"},{"abbreviation":"DiaQuote","comment":"*Correct Dialogue Quotation:*\nRemember that a change in speaker requires a new paragraph. Capitalize the first word in a quoted sentence. Don't capitalize the first word of a continuing quote that was interrupted by a speaker tag.\n*Examples:* She said, \"You are crazy. However,\" she paused, \"it is crazy to be in love with you.\"\nInclude quotation marks before and after the speaker's words. Place commas and periods inside (to the left) of the closing quotation marks.\n*Examples:*\n\"I think you're wrong,\" said Victor.\nSal replied, \"I know I'm right.\"\nWhen dialogue is interrupted by comments or speaker tags, and then continues in the same sentence, begin the rest of the dialogue with a lower case letter.\n*Examples:* \"I realize,\" she paused to think \"that I may have been mistaken.\" \"You are crazy. However,\" she paused, \"it is crazy to be in love with you.\"","id":"DiaQuote0.09604329657581889"},{"abbreviation":"DrQuote","comment":"*Correct Direct Quotation:*\nFollow these rules for direct quotations:\n*▪* When using the exact words of an author, this is known as a _direct quotation_. Include quotation marks before and after the author's exact words. The citation of the author or title and page number are placed within parentheses following the quotation and end with a period.\n*Examples:* The author stated, \"Over 90% of Americans support the law\" (Shetler 32).\n*▪* Don't use _dropped quotations_. A dropped quotation is a direct quotation used without an introduction. Always use a signal phrase to introduce a direct quotation.\n*Signal Phrase Examples:* The author suggests (adds, argues, asserts, cites, claims, describes, discusses, emphasizes, lists illustrates, notes, observes, reports, states)\n*▪* Place question marks and exclamation points inside (to the left) of quotation marks, if part of the quoted sentence, but outside (to the right), if not.\n*Examples:* Dr. Mosely comments, \"What if the studies are proven wrong?\" (Shetler 33). Did Dr. Mosely mean \"studies are proven wrong\"? (Shetler 33).\n*▪* Colons and semicolons go outside the closing quotation marks.\n*Examples:* \"Ask not what your country can do for you. Ask what you can do for your country\" (Kennedy): these words were President John F. Kennedy's most memorable. Kennedy explained, \"We shall pay any price, bear any burden, meet any hardship, support any friend, oppose any foe to assure the survival and success of liberty\"; however, he continued, \"All this will not be completed within the first one hundred days\" (Kennedy).","id":"DrQuote0.17298305218198795"},{"abbreviation":"IndQuote","comment":"*Correct Indirect Quotation:*\nAn _indirect quotation_ uses the author's idea, but not the exact words, so no quotation marks are used. The paraphrase must be accurate to fairly state the author's ideas. Use only your own words to paraphrase.\n*Example:* The author said that the species was endangered (Johns 45).","id":"IndQuote0.7412057562640251"}],"id":"Punctuation, Capitalization, Quotation Rules0.3297304308565727"},{"name":"Spelling Rules","type":"default","comments":[{"type":"text","abbreviation":"dge ge","comment":"*_dge−_ge Spelling Rule Error:*\nSpell a /j/ that ends a syllable with __dge_ if it follows a short vowel sound. Spell a /j/ that ends a syllable with __ge_ if it does not follow a short vowel sound. An ending /j/ sound can also be spelled with a _d_.\n*Examples:* badge, age, graduation","id":"dgege0.1442947038576723"},{"type":"text","abbreviation":"oy oi","comment":"*_oy−_oi Spelling Rule Error:*\nSpell _oy_ at the end of syllables (_joyful_) and _oi_ elsewhere (_ointment_, _point_).","id":"oyoi0.7459529823270017"},{"abbreviation":"Start/k/","comment":"*Starting /k/ Spelling Rule Error:*\nThe starting /k/ sound is spelled _k_ before _e_ and _i_, but _c_ before _o_, _u_, and _a_.\n*Examples:* Ken kisses Coco in a custom car.","id":"Start/k/0.8284484511601033"},{"type":"text","abbreviation":"/ch/","comment":"*/ch/ Spelling Rule Error:*\nSpell the /ch/ sound as __tch_ following short vowels in one-syllable words. Other vowels signal the _ch_ spelling.\n*Examples:* catch, teach\n*Exceptions:* attach, much, rich, such, sandwich, touch, and which","id":"/ch/0.47079993150982835"},{"type":"text","abbreviation":"/k/ch","comment":"*/k/ ch Spelling Rule Error:*\nThe Greek spelling for the starting _/k/_ sound is \"ch.\"\n*Examples:* chorus and chaos","id":"/k/ch0.1266834200313265"},{"type":"text","abbreviation":"lfsz","comment":"_*l, f, s,*_ *and* _*z*_  *Spelling Rule Error:*\nUsually double the _l_, _f_, _s_, or _z_ after short vowels.\n*Examples:* tall, fluff, pass, buzz\n*Exceptions:* yes, quiz, plus, if, this, bus, gas, us","id":"lfsz0.7977492310190855"},{"type":"text","abbreviation":"Drop l","comment":"_*all, till,*_ *and* _*full*_  *Spelling Rule Error:*\nFor syllables ending in _all_, _till_, and _full_, usually drop the _l_ when adding on another syllable. \n*Examples:* almost, until, careful\n*Exceptions:* fullback and fullness","id":"Drop _l_0.5998009992106343"},{"type":"text","abbreviation":"End/k/","comment":"*Ending /k/ Spelling Rule Error:*\nFor _/k/_ sounds at the end of syllables, spell _c_ if the syllable is unaccented (ba-sic̲), but spell _ck_ if the syllable is accented (kic̲k̲-ing). \n*Exceptions*: _stucco_, _occupy_, and _hiccups_.","id":"End/k/0.6312903110698671"},{"type":"text","abbreviation":"ough","comment":"*_ough Spelling Rule Error:*\nThe  _ough_ spelling can have the short _o_, long _o_, _oo_ as in _fool_, or short _u_ sound. Less often, the  _ough_ spelling can also have the /ow/ as in _cow_ sound.\n*Examples:* _bough_ and _plough_.","id":"ough0.027875095232029024"},{"type":"text","abbreviation":"i bef e","comment":"_*i*_ *before* _*e*_ *Spelling Rule Error:*\nUsually spell _i_ before _e_ _(believe)_, but spell _e_ before _i_ after a _c_ _(receive)_ and when the letters are pronounced as a long /a/ sound _(neighbor)_. The rule only applies to the _i_ and _e_ spelling combination within one syllable, so the rule does not apply to words such as _sci-ence_. The rule doesn't apply to plurals of words ending in \"cy.\"\n*Examples:* delicacies, frequencies, vacancies.\n*Exceptions:* neither, either, weird, forfeit, caffeine, height.","id":"_i_ bef _e_0.20521516455897815"},{"type":"text","abbreviation":"Final y","comment":"*Final* _*y* *Rule Spelling Rule Error:*\nKeep the _y_ when adding an ending if the word ends in a vowel, then a _y_ _(delay-delayed)_, or if the ending begins with an _i_ _(copy-copying)_. Change the _y_ to _i_ if the word ends in a consonant, then a _y_ _(pretty-prettiest)_.\n*Examples:* employ−employed, baby−babying, lovely−lovelier\n*Exceptions:* dryly, dryness, shyly, shyness, slyly, and slyness.","id":"Final _y_0.1166315178752304"},{"type":"text","abbreviation":"Silent e","comment":"*Silent* _*e*_ *Rule Spelling Rule Error:*\nDrop the silent _e_ at the end of a root when adding a suffix if that suffix begins with a vowel _(have-having)_. Some British spellings drop the silent final _e_ when the suffix begins with a consonant.\n*Examples:* judgment and argument.\nKeep the silent _e_ when the ending begins with a consonant _(close-closely)_, has a soft _/c/_ or _/g/_ sound-then an \"ous\" _(gorgeous_) or \"able\" _(peaceable)_,or if it ends in \"ee\", \"oe\", or \"ye\" _(freedom, shoeing, eyeing)._","id":"Silent _e_0.7790601495767"},{"type":"text","abbreviation":"DbCons","comment":"*Double the Consonant Rule Spelling Rule Error:*\nFollow these rules for double consonant spellings:\n*▪* Double the ending consonant of a root, when adding a suffix _(permitted)_ if all three of these conditions are met: 1. The last syllable has the accent _(per / mit)_ 2. The last syllable ends in a vowel, then a consonant _(permit)._ 3. The suffix begins with a vowel _(ed)._\n*Examples:* admittance, commitment\n*▪* Don't double the ending consonant of a root when adding a suffix if the root ends in _k_, _w_, _x_, _y_, or _z_.\n*Examples:* locked, knowing, boxed, saying, lazier\n*▪* Don't double the ending consonant of a root when adding a suffix if the root ends in a vowel team followed by a consonant.\n*Examples:* hauling, howling, appealed","id":"DbCons0.6053507627580474"},{"type":"text","abbreviation":"an en","comment":"*\"an\" or \"en\" Suffix Rule Spelling Rule Error:*\nEnd a word with \"ance\", \"ancy\", or \"ant\" if the root before has a hard _/c/_ or _/g/_ sound _(vacancy, arrogance_) or if the root ends with \"ear\" or \"ure\" _(clearance, insurance)_. End a word with \"ence\", \"ency\", or \"ent\" if the root before has a soft _/c/_ or _/g/_ sound _(magnificent, emergency),_ after \"id\" _(residence),_ or if the root ends with \"ere\" _(reverence)._","id":"an en AddQuoteToTitle0.9631599984599102"},{"type":"text","abbreviation":"Able Ible","comment":"*\"able\" or \"ible\" Spelling Rule Error:*\nEnd a word with \"able\" if the root before has a hard _/c/_ or _/g/_ sound _(despicable, navigable),_ after a complete root word _(teachable),_ or after a silent _e (likeable)_. End a word with \"ible\" if the root has a soft _/c/_ or _/g/_ sound _(reducible, legible),_ after an \"ss\" _(admissible),_ or after an incomplete root word _(audible)._","id":"Able ible AddQuoteToTitle0.4398976699248456"},{"type":"text","abbreviation":"/ion/","comment":"*/ion/ Spelling Rule Error:*\nFollow these rules for /ion/ sound spellings:\n*▪* Spell \"sion\" _(illusion)_ for the final _zyun_ sound or the final _shun_ sound _(expulsion, compassion)_ if after an _l_ or _s_. [_sion](http://blog.penningtonpublishing.com/wp-content/uploads/2018/12/sionion-Spelling-Worksheets.pdf)\n*▪* Spell \"cian\" for the final _shun_ sound suffix to indicate a person who does the task of the root _(musician, magician)_ and \"tion\" _(condition)_ in most all other cases. [_cian](http://blog.penningtonpublishing.com/wp-content/uploads/2018/12/cianion-Spelling-Worksheets.pdf)\n*▪* Spell \"tion\" _(condition)_ for the final _shun_ unless after an _l_ or _s_ sound (\"_sion\") or unless the suffix indicates a person (\"_cian\").","id":"_/ion/_0.44357263646315626"},{"type":"text","abbreviation":"Plural","comment":"*Plurals Spelling Rule Error:*\nFollow these rules for plural spellings:\n*▪* To form plurals, add _s_ onto the end of most nouns _(dog-dogs),_ even those that end in _y_ _(day-days)_ or those that end in a vowel, then an _o (stereo-stereos)._\n*▪* To form a plural when a noun ends in these sounds: _/s/_, _/x/_, _/z/_, _/ch/_, or _/sh/_, add \"es\" _(loss-losses, fox-foxes, box-boxes, buzz-buzzes, march-marches, marsh-marshes)_. To form plurals when words end in a consonant, then an _o_, add \"es\" _(potato-potatoes)._\n*▪* To form a plural when a noun ends in a consonant, then a _y_, change the final _y_ to _i_ and add \"es\" _(ferry-ferries)_.\n*▪* To form a plural when a noun ends in \"fe\" or \"lf,\" change these spellings to \"ves\" _(knife-knives, shelf-shelves)._\n*▪* To form a plural of a name ending in _s_, add \"es.\"\n*Examples:* _Jones_ forms the plural _Joneses_ and _Chris_ forms _Chrises_.\n*▪* Some singular nouns do not change spellings when forming plurals.\n*Examples:* aircraft, bison, deer, moose, salmon, sheep, swine, fish,and trout.","id":"Plural0.36102656903113917"}],"id":"Spelling Rules0.3913900424930714"},{"name":"End Comments","type":"default","comments":[{"type":"text","abbreviation":"Potent","comment":"*Potential:*\nFor a first draft this is excellent. For your second draft, focus your revisions on ✖.","id":"Potent0.3091755373315226"},{"type":"text","abbreviation":"Revise","comment":"*Revisions:*\nThe revisions on your first draft have significantly improved this second draft. You can continue to develop your writing by ✖.","id":"Revise0.5417170049184035"},{"type":"text","abbreviation":"Strength","comment":"*Chief Strength:*\nThe chief strength of this writing is ✖. Use this as a model and do more of this throughout ✖.","id":"Strength0.8707789310154448"},{"type":"text","abbreviation":"Connects","comment":"*Connections:*\nYou make a strong connection between ✖ and ✖. Make more of these connections to improve your writing.","id":"Connects0.9364760797368943"},{"type":"text","abbreviation":"Plan","comment":"*Planning:*\nYour writing shows a tremendous amount of careful planning. My key suggestion would be ✖.","id":"Plan0.059273152836152976"},{"type":"text","abbreviation":"Research","comment":"*Research:*\nYou have researched this topic thoroughly. One more suggestion would be to ✖.","id":"Research0.8545160565145351"},{"type":"text","abbreviation":"Original","comment":"*Originality:*\nYour writing demonstrates a significant amount of original thought. To improve your final draft, focus on ✖.","id":"Original0.9420792035551138"},{"type":"text","abbreviation":"Content","comment":"*Content:*\nThe content and ideas presented throughout are terrific. Consider ✖.","id":"Content0.3549273541159086"},{"type":"text","abbreviation":"Audience","comment":"*Audience:*\nYou have done a great job writing to your audience in this first draft. Think about adding the following: ✖","id":"Audience0.16820853995065654"},{"type":"text","abbreviation":"Opinion","comment":"*Opinion:*\nYou have provided convincing and well-chosen evidence throughout this essay to support your opinion. To make your argument even more conclusive, try ✖.","id":"Opinion0.19702306559169003"},{"type":"text","abbreviation":"Purpose","comment":"*Purpose:*\nYou have kept the main focus on the purpose of your thesis statement throughout this essay. What you need to do now is ✖.","id":"Purpose0.45631425719810115"},{"type":"text","abbreviation":"Charact","comment":"*Characterization:*\nYour character development is creative and thorough in this story. However, ✖.","id":"Charact0.8789509123377452"},{"type":"text","abbreviation":"PlotDev","comment":"*Plot Development:*\nYour plot development includes all the needed parts to effective story-telling. For additional revision, you might ✖.","id":"PlotDev0.5422952319504011"},{"type":"text","abbreviation":"Dialg","comment":"*Dialogue:*\nYour use of dialogue is realistic, and you have a variety of speaker tags. You might ✖.","id":"Dialg0.035308764710823004"},{"abbreviation":"Edit","comment":"*Edit and Complete Final Draft:*\nSpell check and ask others to edit by suggestion additions, deletions, corrections, and substitutions. Afterwards, complete your final edit, resolve the comments, click the \"Editing\" tab in the upper right corner of your Google doc and select the \"Viewing\" dropdown to re-read. If satisfied that this is your best work, share your document. I look forward to reading your final draft.","id":"Edit0.9964959010253118"}],"id":"End Comments0.06114956788278958"}],"setName":"elementary"}